/*------------------------------------------------------------------------------*
 * File Name: File.h															*
 * Creation: 4/2/2001															*
 * Purpose: Origin C header	for File class and other related functions			*
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 4/27/05 QA70-5088 v8.0227 UPDATE_READSTRING_DESCRIPTION					*
 *------------------------------------------------------------------------------*/

#ifndef _FILE_H
#define _FILE_H

#include <common.h> // must always include this
#include <string.h> // most likely you will also need strings

//constants for file nOpenFlags
//CPY, we will change into enum later
/*
enum {
	modeRead =          0x0000,
	modeWrite =         0x0001,
	modeReadWrite =     0x0002,
	shareCompat =       0x0000,
	shareExclusive =    0x0010,
	shareDenyWrite =    0x0020,
	shareDenyRead =     0x0030,
	shareDenyNone =     0x0040,
	modeNoInherit =     0x0080,
	modeCreate =        0x1000,
	modeNoTruncate =    0x2000,
	typeText =          0x4000, // typeText and typeBinary are used in
	typeBinary =   (int)0x8000 // derived classes only
};
*/
#define	file::modeRead			0x0000
#define	file::modeWrite			0x0001
#define	file::modeReadWrite		0x0002
#define	file::shareCompat		0x0000
#define	file::shareExclusive	0x0010
#define	file::shareDenyWrite	0x0020
#define	file::shareDenyRead		0x0030
#define	file::shareDenyNone		0x0040
#define	file::modeNoInherit		0x0080
#define	file::modeCreate		0x1000
#define	file::modeNoTruncate	0x2000
#define	file::typeText			0x4000 // typeText and typeBinary are used in
#define	file::typeBinary		((int)0x8000) // derived classes only
	

#define file::hFileNull		    0

#define file::begin		    	0
#define file::current			1
#define file::end				2

//constants for file Error Code 
#define FileError::none					0	//No error occurred.
#define FileError::generic				1	//An unspecified error occurred.
#define FileError::fileNotFound			2	//The file could not be located.
#define FileError::badPath				3	//All or part of the path is invalid.
#define FileError::tooManyOpenFiles		4	//The permitted number of open files was exceeded.
#define FileError::accessDenied			5	//The file could not be accessed.
#define FileError::invalidFile			6	//There was an attempt to use an invalid file handle.
#define FileError::removeCurrentDir		7	//The current working directory cannot be removed.
#define FileError::directoryFull		8	//There are no more directory entries.
#define FileError::badSeek				9	//There was an error trying to set the file pointer.
#define FileError::hardIO				10	//There was a hardware error.
#define FileError::sharingViolation		11	//SHARE.EXE was not loaded, or a shared region was locked.
#define FileError::lockViolation		12	//There was an attempt to lock a region that was already locked.
#define FileError::diskFull				13	//The disk is full.
#define FileError::endOfFile			14	//The end of file was reached. 


// Comments last updated by Frank on 08/08/04
/**+
http://ocwiki.originlab.com/index.php?title=Category:file_(class)
*/
class file
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-file
	*/
	file(); // Set the public data member m_hFile to a null value. 
	
	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-file
	*/
	file(LPCTSTR lpszFileName, UINT nOpenFlags); // Create a File object and open the file having the specified path.

	// Attributes
	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-GetLastError
	*/
	UINT	GetLastError();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-IsOpen
	*/
	BOOL IsOpen();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-GetPosition
	*/
	LONG    GetPosition();

	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-Open
	*/
	BOOL	Open(LPCTSTR lpszFileName, UINT nOpenFlags); // Open a file returning FALSE or 0 on failure and TRUE or a non-zero on success.
	
	// Comments last updated by Cheney on 06/19/06
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-Read
	*/
	UINT	Read(void *lpBuf, UINT nCount);

	// Comments last updated by Cheney on 06/19/06
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-Write
	*/
	UINT	Write(const void *lpBuf, UINT nCount);
     
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-GetHandle
	*/
	UINT GetHandle();	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-Seek
	*/
	LONG	Seek(LONG lOffset, UINT nFrom);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-SeekToBegin
	*/
	void	SeekToBegin();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-SeekToEnd
	*/
	LONG	SeekToEnd();	

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-Flush
	*/
	BOOL	Flush();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-Close
	*/
	BOOL	Close(); // Close the file associated with the indicated file object.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-GetLength
	*/
	DWORD GetLength();

	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-ReadInt
	*/
	UINT ReadInt(void *pDestBuffer, int nDataTypeSize, UINT nItemCount, BOOL bIsLittleEndian = TRUE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-WriteInt
	*/
	UINT WriteInt(void *pSrcBuffer, int nDataTypeSize, UINT nItemCount, BOOL bIsLittleEndian = TRUE);
	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-ReadFloat
	*/
	UINT ReadFloat(void *pDestBuffer, int nDataTypeSize, UINT nItemCount, BOOL bIsLittleEndian = TRUE);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:file-WriteFloat
	*/
	UINT WriteFloat(void *pSrcBuffer, int nDataTypeSize, UINT nItemCount, BOOL bIsLittleEndian = TRUE);

};


/**+
http://ocwiki.originlab.com/index.php?title=Category:stdioFile_(class)
*/
class stdioFile : public file
{

public:
	// Constructors
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-stdioFile
	*/
	stdioFile();
	
	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-stdioFile
	*/
	stdioFile(LPCTSTR lpszFileName, UINT nOpenFlags);

	// Operations
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-WriteString
	*/
	int WriteString(LPCTSTR lpcsz);

	// Comments last updated by Frank on 08/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-ReadString
	*/
	BOOL ReadString(string& str, DWORD dwCntrl = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-Scan
	*/
	int Scan(int nSize, stdioFileInfo* pfileInfo, BOOL bUnicode = false);

	// Comments last updated by Cheney on 2006-12-28
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-CheckUniCodeBOM
	*/
	int	CheckUniCodeBOM();
	
	// Comments last updated by Cheney on 2006-12-28
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:stdioFile-SetUniCodeType
	*/
	BOOL SetUniCodeType(int nUniCodeType);
};

#endif //_FILE_H
